ALTER SESSION SET EXPLAIN PLAN = ON;
ALTER SYSTEM SET TRCLOG_EXPLAIN_GRAPH = 1;

SET TIMING ON;
SET TIMESCALE MILSEC;

CREATE VIEW REVENUE ( SUPPLIER_NO, TOTAL_REVENUE )
    AS SELECT L_SUPPKEY,
              SUM(L_EXTENDEDPRICE * (1 - L_DISCOUNT))
       FROM LINEITEM
       WHERE L_SHIPDATE >= DATE'01-Jan-1996'
         AND L_SHIPDATE < ADD_MONTHS(DATE'01-Jan-1996', 3)
       GROUP BY L_SUPPKEY;

SELECT S_SUPPKEY,
       S_NAME,
       S_ADDRESS,
       S_PHONE,
       TOTAL_REVENUE
FROM SUPPLIER,
     REVENUE
WHERE S_SUPPKEY = SUPPLIER_NO
  AND TOTAL_REVENUE = ( SELECT MAX(TOTAL_REVENUE) FROM REVENUE )
ORDER BY S_SUPPKEY; 

DROP VIEW REVENUE;

ALTER SYSTEM SET TRCLOG_EXPLAIN_GRAPH = 0;
