ALTER SESSION SET EXPLAIN PLAN = ON;
ALTER SYSTEM SET TRCLOG_EXPLAIN_GRAPH = 1;

SET TIMING ON;
SET TIMESCALE MILSEC;

SELECT
    O_ORDERPRIORITY,
    COUNT(*) AS ORDER_COUNT
FROM
    ORDERS
WHERE
    O_ORDERDATE >= DATE'01-JUL-1993'
    AND O_ORDERDATE < ADD_MONTHS('01-JUL-1993', 3)
    AND EXISTS ( SELECT *
		         FROM LINEITEM
    	         WHERE L_ORDERKEY = O_ORDERKEY
	               AND L_COMMITDATE < L_RECEIPTDATE )
GROUP BY O_ORDERPRIORITY
ORDER BY O_ORDERPRIORITY;

ALTER SYSTEM SET TRCLOG_EXPLAIN_GRAPH = 0;

