ALTER SESSION SET EXPLAIN PLAN = ON;
--ALTER SYSTEM SET TRCLOG_EXPLAIN_GRAPH = 1;

SET TIMING ON;
SET TIMESCALE MILSEC;

SELECT 
       O_YEAR,
       SUM( CASE2 (NATION = 'BRAZIL', VOLUME, 0) ) 
       / SUM(VOLUME) AS MKT_SHARE
FROM ( SELECT EXTRACT(O_ORDERDATE, 'YEAR') AS O_YEAR,
              L_EXTENDEDPRICE * (1 - L_DISCOUNT) AS VOLUME,
              N2.N_NAME AS NATION
        FROM PART,
             SUPPLIER,
             LINEITEM,
             ORDERS,
             CUSTOMER,
             NATION N1,
             NATION N2,
             REGION
       WHERE P_PARTKEY = L_PARTKEY
         AND S_SUPPKEY = L_SUPPKEY
         AND L_ORDERKEY = O_ORDERKEY
         AND O_CUSTKEY = C_CUSTKEY
         AND C_NATIONKEY = N1.N_NATIONKEY
         AND N1.N_REGIONKEY = R_REGIONKEY
         AND R_NAME = 'AMERICA'
         AND S_NATIONKEY = N2.N_NATIONKEY
         AND O_ORDERDATE BETWEEN DATE'01-JAN-1995' 
                         AND DATE'31-DEC-1996'
         AND P_TYPE = 'ECONOMY ANODIZED STEEL'
     ) ALL_NATIONS
GROUP BY O_YEAR
ORDER BY O_YEAR;

ALTER SYSTEM SET TRCLOG_EXPLAIN_GRAPH = 0;
