/** 
 *  Copyright (c) 1999~2017, Altibase Corp. and/or its affiliates. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License, version 3,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 
/***********************************************************************
 * $Id: iloFormLexer.l 80545 2017-07-19 08:05:23Z daramix $
 **********************************************************************/
/***********************************************************************
 * ATTENTION : 
 ***********************************************************************
 * This file must be generated by flex 2.5.33 with -R option
 * If you update iloFormLexer.l, please follow this procedure.
 1) make formclean
 2) make form
 3) commit iloFormLexer.l
 4) commit iloFormLexer.cpp
 **********************************************************************/

%option reentrant
%option 8bit
%option caseless
%option nounput noyymore noyywrap
%option prefix = "Form"
%option bison-bridge
%option stack
%{
/* This is Lex Source for lexical Analysis of iLoader Form file */
//#define _ILOADER_DEBUG
//#undef  _ILOADER_DEBUG

#include <ilo.h>

#if defined(BISON_POSTFIX_HPP)
#include "iloFormParser.hpp"
#else /* BISON_POSTFIX_CPP_H */
#include "iloFormParser.cpp.h"
#endif

#define YY_DECL int FormLex(YYSTYPE * yylval_param,  yyscan_t yyscanner, iloaderHandle *param )

#define FORM_START (((((struct yyguts_t*)yyscanner)->yy_start) - 1) / 2) 
#define FORMSTATE FORM_START

/*
 * BUGBUG
 * for some reason, ECHO was defined badly as 0000010
 * the suspects as the followings..
 * /usr/include/asm-i386/termbits.h:#define ECHO   0000010
 * /usr/include/asm-x86_64/termbits.h:#define ECHO 0000010
 * /usr/include/bits/termios.h:#define ECHO        0000010
 * So, I remove define of ECHO as the following for removing compiler warnings..
 * Then, flex can define ECHO correctly..
 */
#if defined(ECHO)
# undef ECHO
#endif

void removeEscapeChars(SChar *aStr);
%}

NEG_TRAIL_CH     [\x80-\xFF]

POS_TRAIL_CH     [\x81-\xFE][\x40-\x7E\x80-\xFE]

SJIS_HWKATA      [\xA0-\xDF]
SJIS_JIS97       [\x81-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]
SJIS_ALL         ({SJIS_HWKATA})|({SJIS_JIS97})

%start COMMENT

%s NEG_TRAIL
%s POS_TRAIL
%s SJIS

%%

"#".*                          ;
"/*"                           yy_push_state(COMMENT, yyscanner);
<COMMENT>"*/"                  yy_push_state(param->mParser.mIloFLStartState, yyscanner);
<COMMENT>.|\n                  ;
"{"                            {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token '{'\n");
#endif
                                   return T_LBRACE;
                               }
"}"                            {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token '}'\n");
#endif
                                   return T_RBRACE;
                               }
"("                            {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token '('\n");
#endif
                                   return T_LBRACKET;
                               }
")"                            {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token ')'\n");
#endif
                                   return T_RBRACKET;
                               }
","                            {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token ','\n");
#endif
                                   return T_COMMA;
                               }
";"                            {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token ';'\n");
#endif
                                   return T_SEMICOLON;
                               }
"."                            {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token '.'\n");
#endif
                                   return T_PERIOD;
                               }

[Dd][Oo][Ww][Nn][Ll][Oo][Aa][Dd] {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token 'download'\n");
#endif
                                   int t_len = idlOS::strlen(yytext);

                                   yyget_lval(yyscanner)->str=(SChar*)(param->m_memmgr->alloc(t_len+1));
                                   idlOS::memcpy(yyget_lval(yyscanner)->str, yytext, t_len);
                                   (yyget_lval(yyscanner)->str)[t_len] = '\0';
                                   /* BUG-18997 */
                                   yy_push_state(param->mParser.mIloFLStartState, yyscanner);
                                   return T_DOWNLOAD;
                               }
[Cc][Oo][Nn][Dd][Ii][Tt][Ii][Oo][Nn] {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token 'condition'\n");
#endif
                                   int t_len = idlOS::strlen(yytext);

                                   yyget_lval(yyscanner)->str=(SChar*)(param->m_memmgr->alloc(t_len+1));
                                   idlOS::memcpy(yyget_lval(yyscanner)->str, yytext, t_len);
                                   (yyget_lval(yyscanner)->str)[t_len] = '\0';

                                   return T_CONDITION;
                               }
[Ss][Ee][Qq][Uu][Ee][Nn][Cc][Ee] {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token 'sequence'\n");
#endif
                                   int t_len = idlOS::strlen(yytext);

                                   yyget_lval(yyscanner)->str=(SChar*)(param->m_memmgr->alloc(t_len+1));
                                   idlOS::memcpy(yyget_lval(yyscanner)->str, yytext, t_len);
                                   (yyget_lval(yyscanner)->str)[t_len] = '\0';

                                   return T_SEQUENCE;
                               }
[Tt][Aa][Bb][Ll][Ee]           {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token 'table'\n");
#endif
                                   /* BUG-18997 */
                                   yy_push_state(param->mParser.mIloFLStartState, yyscanner);
                                   return T_TABLE;
                               }
[Qq][Uu][Ee][Uu][Ee]           {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token 'queue'\n");
#endif
                                   int t_len = idlOS::strlen(yytext);

                                   yyget_lval(yyscanner)->str=(SChar*)(param->m_memmgr->alloc(t_len+1));
                                   idlOS::memcpy(yyget_lval(yyscanner)->str, yytext, t_len);
                                   (yyget_lval(yyscanner)->str)[t_len] = '\0';
                                   /* BUG-18997 */
                                   yy_push_state(param->mParser.mIloFLStartState, yyscanner);
                                   return T_QUEUE;
                               }
[Hh][Ii][Nn][Tt]               {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token HINT\n");
#endif
                                   int t_len = idlOS::strlen(yytext);

                                   yyget_lval(yyscanner)->str=(SChar*)(param->m_memmgr->alloc(t_len+1));
                                   idlOS::memcpy(yyget_lval(yyscanner)->str, yytext, t_len);
                                   (yyget_lval(yyscanner)->str)[t_len] = '\0';
                                   /* BUG-18997 */
                                   yy_push_state(param->mParser.mIloFLStartState, yyscanner);
                                   return T_HINT;
                               }
[Nn][Oo][Ee][Xx][Pp]           {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token 'noexp'\n");
#endif
                                   int t_len = idlOS::strlen(yytext);

                                   yyget_lval(yyscanner)->str=(SChar*)(param->m_memmgr->alloc(t_len+1));
                                   idlOS::memcpy(yyget_lval(yyscanner)->str, yytext, t_len);
                                   (yyget_lval(yyscanner)->str)[t_len] = '\0';
                                   return T_NOEXP;
                               }
[Oo][Uu][Tt][Ff][Ii][Ll][Ee]   {
//PROJ-2030, CT_CASE-3020 CHAR outfile  
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token 'outfile'\n");
#endif
                                   int t_len = idlOS::strlen(yytext);

                                   yyget_lval(yyscanner)->str=(SChar*)(param->m_memmgr->alloc(t_len+1));
                                   idlOS::memcpy(yyget_lval(yyscanner)->str, yytext, t_len);
                                   (yyget_lval(yyscanner)->str)[t_len] = '\0';
                                   return T_OUTFILE;
                               }
[Ss][Kk][Ii][Pp]               {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token 'skip'\n");
#endif
                                   int t_len = idlOS::strlen(yytext);

                                   yyget_lval(yyscanner)->str=(SChar*)(param->m_memmgr->alloc(t_len+1));
                                   idlOS::memcpy(yyget_lval(yyscanner)->str, yytext, t_len);
                                   (yyget_lval(yyscanner)->str)[t_len] = '\0';
                                   return T_SKIP;
                               }
[Dd][Ee][Ff][Aa][Uu][Ll][Tt]   {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token 'default'\n");
#endif
                                   return T_TIMESTAMP_DEFAULT;
                               }
[Bb][Ii][Nn][Aa][Rr][Yy]       {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token 'binary'\n");
#endif
                                   int t_len = idlOS::strlen(yytext);

                                   yyget_lval(yyscanner)->str=(SChar*)(param->m_memmgr->alloc(t_len+1));
                                   idlOS::memcpy(yyget_lval(yyscanner)->str, yytext, t_len);
                                   (yyget_lval(yyscanner)->str)[t_len] = '\0';
                                   return T_BINARY;
                               }
[Nn][Uu][Ll][Ll]               {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token 'null'\n");
#endif
                                   return T_TIMESTAMP_NULL;
                               }
[Aa][Dd][Dd]                   {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token 'add'\n");
#endif
                                   return T_ADD;
                               }
[Dd][Aa][Tt][Ee][Ff][Oo][Rr][Mm] {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token 'dateform'\n");
#endif
                                   int t_len = idlOS::strlen(yytext);

                                   yyget_lval(yyscanner)->str=(SChar*)(param->m_memmgr->alloc(t_len+1));
                                   idlOS::memcpy(yyget_lval(yyscanner)->str, yytext, t_len);
                                   (yyget_lval(yyscanner)->str)[t_len] = '\0';
                                   return T_DATEFORMAT_CMD;
                               }
"Y"{2,4}[/-]?"MM"[/-]?"DD"     |
"DD"[/-]?"MM"[/-]?"Y"{2,4}     |
"MM"[/-]?"DD"[/-]?"Y"{2,4}     |
"DD"[/-]?"MON"[/-]?"Y"{2,4}    {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token Identifier [%s]\n", yytext);
#endif
                                   int t_len = idlOS::strlen(yytext);

                                   yyget_lval(yyscanner)->str=(SChar*)(param->m_memmgr->alloc(t_len+1));
                                   idlOS::memcpy(yyget_lval(yyscanner)->str, yytext, t_len);
                                   (yyget_lval(yyscanner)->str)[t_len] = '\0';

                                   return T_DATEFORMAT;
                               }
"'"[^']*"'"                    {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token Identifier [%s]\n", yytext);
#endif
                                   int t_len = idlOS::strlen(yytext);

                                   yyget_lval(yyscanner)->str=(SChar*)(param->m_memmgr->alloc(t_len+1));
                                   idlOS::memcpy(yyget_lval(yyscanner)->str, yytext, t_len);
                                   (yyget_lval(yyscanner)->str)[t_len] = '\0';

                                   return T_OPTIONAL_DATEFORMAT;
                               }
"HH"{0,1}[:/]?"MI"{0,1}[:/]?"SS"{0,1}[:/.]?"SSSSSS"{0,1}  |
"HH24"{0,1}[:/]?"MI"{0,1}[:/]?"SS"{0,1}[:/.]?"SSSSSS"{0,1}  {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token Identifier [%s]\n", yytext);
#endif
                                   int t_len = idlOS::strlen(yytext);

                                   yyget_lval(yyscanner)->str=(SChar*)(param->m_memmgr->alloc(t_len+1));
                                   idlOS::memcpy(yyget_lval(yyscanner)->str, yytext, t_len);
                                   (yyget_lval(yyscanner)->str)[t_len] = '\0';

                                   return T_TIMEFORMAT;
                               }
("Y"{2,4}){0,1}"MMDDHH"{0,1}"MI"{0,1}"SS"{0,1}"SSSSSS"{0,1}     |
("Y"{2,4}){0,1}"MMDDHH24"{0,1}"MI"{0,1}"SS"{0,1}"SSSSSS"{0,1}     {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token Identifier [%s]\n", yytext);
#endif
                                   int t_len = idlOS::strlen(yytext);

                                   yyget_lval(yyscanner)->str=(SChar*)(param->m_memmgr->alloc(t_len+1));
                                   idlOS::memcpy(yyget_lval(yyscanner)->str, yytext, t_len);
                                   (yyget_lval(yyscanner)->str)[t_len] = '\0';

                                   return T_NOTERM_DATEFORMAT;
                               }
[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]([0-9][0-9][0-9][0-9][0-9][0-9]){0,1} {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token T_TIMESTAMP_VALUE [%s]\n", yytext);
#endif
                                   int t_len = idlOS::strlen(yytext);

                                   yyget_lval(yyscanner)->str=(SChar*)(param->m_memmgr->alloc(t_len+1));
                                   idlOS::memcpy(yyget_lval(yyscanner)->str, yytext, t_len);
                                   (yyget_lval(yyscanner)->str)[t_len] = '\0';

                                   return T_TIMESTAMP_VALUE;
                               }
[Dd][Aa][Tt][Aa]_[Nn][Ll][Ss]_[Uu][Ss][Ee] {
// ex) DATA_NLS_USE=KO16KSC5601
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token 'data_nls_use'\n");
#endif
                                   int t_len = idlOS::strlen(yytext);

                                   yyget_lval(yyscanner)->str=(SChar*)(param->m_memmgr->alloc(t_len+1));
                                   idlOS::memcpy(yyget_lval(yyscanner)->str, yytext, t_len);
                                   (yyget_lval(yyscanner)->str)[t_len] = '\0';
                                   yy_push_state(param->mParser.mIloFLStartState, yyscanner);
                                   return T_DATA_NLS_USE;
                               }
[Pp][Aa][Rr][Tt][Ii][Tt][Ii][Oo][Nn] {
/* BUG-30467 */
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token 'PARTITION'\n");
#endif
                                   int t_len = idlOS::strlen(yytext);

                                   yyget_lval(yyscanner)->str=(SChar*)(param->m_memmgr->alloc(t_len+1));
                                   idlOS::memcpy(yyget_lval(yyscanner)->str, yytext, t_len);
                                   (yyget_lval(yyscanner)->str)[t_len] = '\0';
                                   return T_PARTITION;
                               }
[Nn][Cc][Hh][Aa][Rr]_[Uu][Tt][Ff]16   {
// ex) NCHAR_UTF16=YES
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token 'nchar_utf16'\n");
#endif
                                   int t_len = idlOS::strlen(yytext);

                                   yyget_lval(yyscanner)->str=(SChar*)(param->m_memmgr->alloc(t_len+1));
                                   idlOS::memcpy(yyget_lval(yyscanner)->str, yytext, t_len);
                                   (yyget_lval(yyscanner)->str)[t_len] = '\0';
                                   yy_push_state(param->mParser.mIloFLStartState, yyscanner);
                                   return T_NCHAR_UTF16;
                               }
"="                            {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token '='\n");
#endif
                                   return T_ASSIGN;
                               }
[1-9][0-9]*                    {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token Identifier [%s]\n", yytext);
#endif
                                   yyget_lval(yyscanner)->num = atoi((char *)yytext);
                                   return T_NUMBER;
                               }
[\-][1-9][0-9]*                {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token Identifier [%s]\n", yytext);
#endif
                                   yyget_lval(yyscanner)->num = atoi((char *)yytext);
                                   return T_NUMBER;
                               }
"0"                            {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token Identifier [%s]\n", yytext);
#endif
                                   yyget_lval(yyscanner)->num = 0;
                                   return T_ZERO;
                               }
<NEG_TRAIL>([_a-zA-Z]|({NEG_TRAIL_CH}))([a-zA-Z0-9_$#]|({NEG_TRAIL_CH}))* {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token Identifier [%s]\n", yytext);
#endif
                                   int t_len = idlOS::strlen(yytext);

                                   yyget_lval(yyscanner)->str=(SChar*)(param->m_memmgr->alloc(t_len+1));
                                   idlOS::memcpy(yyget_lval(yyscanner)->str, yytext, t_len);
                                   (yyget_lval(yyscanner)->str)[t_len] = '\0';

                                   return T_IDENTIFIER;
                               }
<POS_TRAIL>([_a-zA-Z]|({POS_TRAIL_CH}))([a-zA-Z0-9_$#]|({POS_TRAIL_CH}))* {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token Identifier [%s]\n", yytext);
#endif
                                   int t_len = idlOS::strlen(yytext);

                                   yyget_lval(yyscanner)->str=(SChar*)(param->m_memmgr->alloc(t_len+1));
                                   idlOS::memcpy(yyget_lval(yyscanner)->str, yytext, t_len);
                                   (yyget_lval(yyscanner)->str)[t_len] = '\0';

                                   return T_IDENTIFIER;
                               }
<SJIS>([_a-zA-Z]|({SJIS_ALL}))([a-zA-Z0-9_$#]|({SJIS_ALL}))* {
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token Identifier [%s]\n", yytext);
#endif
                                   int t_len = idlOS::strlen(yytext);

                                   yyget_lval(yyscanner)->str=(SChar*)(param->m_memmgr->alloc(t_len+1));
                                   idlOS::memcpy(yyget_lval(yyscanner)->str, yytext, t_len);
                                   (yyget_lval(yyscanner)->str)[t_len] = '\0';

                                   return T_IDENTIFIER;
                               }
[_a-zA-Z][a-zA-Z0-9]*"-"[a-zA-Z0-9]* {
// bug-23282: formout file parsing: ex) DATA_NLS_USE=EUC-JP (or SHIFT-JIS)
#ifdef _ILOADER_DEBUG
                                   idlOS::printf("Token Identifier [%s]\n", yytext);
#endif
                                   int t_len = idlOS::strlen(yytext);

                                   yyget_lval(yyscanner)->str=(SChar*)(param->m_memmgr->alloc(t_len+1));
                                   idlOS::memcpy(yyget_lval(yyscanner)->str, yytext, t_len);
                                   (yyget_lval(yyscanner)->str)[t_len] = '\0';

                                   return T_CHARSET;
                               }

"\""[ \n\r\t]*[Ww][Hh][Ee][Rr][Ee][ \n\r\t]+([^"]|\"\")*"\""  {
/* BUG-40363 To handle where condition strings having double quotation marks */
/* BUG-40310 [ux-iloader] Fail to handle where condition when 'WHERE' keyword has mixed case. */

    /* eraseDQuotesԼ double quotes ߿ ڸ.
     * table/column/sequence ̸  "..." ڿ  ʿϱ .
     */
    int t_len = idlOS::strlen(yytext);
    yyget_lval(yyscanner)->str=(SChar*)(param->m_memmgr->alloc(t_len+1));
    idlOS::memcpy(yyget_lval(yyscanner)->str, yytext, t_len);
    (yyget_lval(yyscanner)->str)[t_len] = '\0';

    removeEscapeChars( yyget_lval(yyscanner)->str );

#ifdef _ILOADER_DEBUG
    idlOS::printf("Token WHERE [%s]\n", yyget_lval(yyscanner)->str);
#endif
    return T_WHERE;
}

"\""([^"]|\"\")*"\"" {
/* BUG-40363 To handle strings having double quotation marks */

    /* BUG-17563 : iloader  ūǥ ̿ Naming Rule    */
    /* eraseDQuotesԼ double quotes ߿ ڸ.
     * table/column/sequence ̸  "..." ڿ  ʿϱ .
     */
    int t_len = idlOS::strlen(yytext);
    yyget_lval(yyscanner)->str=(SChar*)(param->m_memmgr->alloc(t_len+1));
    idlOS::memcpy(yyget_lval(yyscanner)->str, yytext, t_len);
    (yyget_lval(yyscanner)->str)[t_len] = '\0';

    removeEscapeChars( yyget_lval(yyscanner)->str );

#ifdef _ILOADER_DEBUG
    idlOS::printf("Token STRING [%s]\n", yyget_lval(yyscanner)->str);
#endif
    return T_STRING;
}

<<EOF>>                        {
                                   yyterminate();
                               }

[ \t\n]+                       ;
[ \t\r\n]+                     ;
.|\n|\r\n                      {
                                   return yytext[0];
                               }

%%

/* double quotation  ִ ""  "  */
void removeEscapeChars(SChar *aStr)
{
    static SChar sEsc = '"';
    SChar *sSrc = NULL;
    SChar *sDst = NULL;

    for(sSrc = sDst = aStr; *sSrc != '\0'; sSrc++)
    {
        if ( *sSrc != sEsc )
        {
            *(sDst++) = *sSrc;
        }
        else
        {
            if ( *(sSrc+1) != '\0' &&
                 *(sSrc+1) == sEsc )
            {
                *(sDst++) = sEsc;
                sSrc++;
            }
            else
            {
                *(sDst++) = *sSrc;
            }
        }
    }
    *sDst = '\0';
}

void
Formerror( yyscan_t yyscanner, void *, const SChar * /*s*/)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    /*printf("Error:: %s \n", yytext);*/
#if YY_FLEX_MAJOR_VERSION == 2 && YY_FLEX_MINOR_VERSION == 5 && !defined(YY_FLEX_SUBMINOR_VERSION)
    yy_flush_buffer( yy_curent_buffer, yyscanner );
#else
    yy_flush_buffer( YY_CURRENT_BUFFER, yyscanner );
#endif
}

int yylex(YYSTYPE* lvalp, yyscan_t yyscanner, void* aParam )
{
    SInt   sRes;
    SChar *sNlsUse;
    SChar sDefaultNLS[] = "US7ASCII";
    
    iloaderHandle *sHandle = (iloaderHandle *) aParam;
    
    if( sHandle->mParser.mCharType == IDN_CF_UNKNOWN )
    {
        sNlsUse = idlOS::getenv(ALTIBASE_ENV_PREFIX"NLS_USE");
        if( sNlsUse == NULL )
        {
            sNlsUse = sDefaultNLS;
        }

        if( ( idlOS::strncmp( sNlsUse, (SChar*)"SHIFT-JIS", 9 ) == 0 ) ||
            ( idlOS::strncmp( sNlsUse, (SChar*)"SHIFTJIS", 8 ) == 0 ) ||
            ( idlOS::strncmp( sNlsUse, (SChar*)"JAPANESE", 8 ) == 0 ) ||
            /* PROJ-2590 [ɼ] CP932 database character set  */
            ( idlOS::strncmp( sNlsUse, (SChar*)"MS932", 5 ) == 0 ) ||
            ( idlOS::strncmp( sNlsUse, (SChar*)"CP932", 5 ) == 0 ) ||
            ( idlOS::strncmp( sNlsUse, (SChar*)"WINDOWS932", 10 ) == 0 ) )
        {
            sHandle->mParser.mCharType = IDN_CF_SJIS;
        }
        else if( ( idlOS::strncmp( sNlsUse, (SChar*)"GB231280", 8 ) == 0 )   ||
                 (idlOS::strncmp( sNlsUse, (SChar*)"ZHS16CGB231280", 14)==0) ||
                 ( idlOS::strncmp( sNlsUse, (SChar*)"CHINESE", 7 )==0 ) ||
                 /* PROJ-2414 [ɼ] GBK, CP936 character set ߰ */
                 ( idlOS::strncmp( sNlsUse, (SChar*)"MS936", 5 )==0 ) ||
                 ( idlOS::strncmp( sNlsUse, (SChar*)"CP936", 5 )==0 ) ||
                 ( idlOS::strncmp( sNlsUse, (SChar*)"GBK", 3 )==0 ) ||
                 ( idlOS::strncmp( sNlsUse, (SChar*)"ZHS16GBK", 8 )==0 ) ||
                 ( idlOS::strncmp( sNlsUse, (SChar*)"WINDOWS936", 10 )==0 ) ||
                 ( idlOS::strncmp( sNlsUse, (SChar*)"BIG5", 4 )==0 ) ||
                 ( idlOS::strncmp( sNlsUse, (SChar*)"ZHT16BIG5", 9 )==0 ) ||
                 ( idlOS::strncmp( sNlsUse, (SChar*)"TAIWAN", 6 )==0 ) ||
                 ( idlOS::strncmp( sNlsUse, (SChar*)"MS949", 5 )==0 ) ||
                 ( idlOS::strncmp( sNlsUse, (SChar*)"CP949", 5 )==0 ) ||
                 ( idlOS::strncmp( sNlsUse, (SChar*)"WINDOWS949", 10 ) == 0 ) )
        {
            sHandle->mParser.mCharType = IDN_CF_POS_TRAIL;
        }
        else
        {
            sHandle->mParser.mCharType = IDN_CF_NEG_TRAIL;
        }
    }

    if( FORMSTATE == INITIAL )
    {
        if( sHandle->mParser.mCharType == IDN_CF_SJIS )
        {
            sHandle->mParser.mIloFLStartState = SJIS;
        }
        else if( sHandle->mParser.mCharType == IDN_CF_POS_TRAIL )
        {
            sHandle->mParser.mIloFLStartState = POS_TRAIL;
            yy_push_state(POS_TRAIL, yyscanner);
        }
        else
        {
            sHandle->mParser.mIloFLStartState = NEG_TRAIL;
            yy_push_state(NEG_TRAIL,yyscanner);
        }
        yy_push_state(sHandle->mParser.mIloFLStartState,yyscanner);
    }

   sRes = FormLex( lvalp, yyscanner, sHandle );

   return sRes;
}

char *
ltrim(char *s)
{
   char *p = s;

   while (*p == ' ' && idlOS::strlen(p) > 0)
      p++;

   // BUG-25208[CodeSonar] ޸  ߻ 
   idlOS::memmove(s, p, (idlOS::strlen(p)+1));

   return s;
}

char *
rtrim(char *s)
{
   char *str;

   str = s + idlOS::strlen(s)-1;
   for (; s<str; str--)
   {
      if (*str == ' ')
         *str = (char) 0;
      else
         break;
   }

   return s;
}

/* BUG-17563 : iloader  ūǥ ̿ Naming Rule    */
/* double quotesڸ ߶󳻴 Լ. */
SChar *eraseDQuotes(SChar *aSrc)
{
    UInt  sLen;
    // sLen ׻ 2 ũ "..."
    sLen = idlOS::strlen(aSrc);
    aSrc[sLen-1] = '\0';
    return aSrc+1;
}
