/** 
 *  Copyright (c) 1999~2017, Altibase Corp. and/or its affiliates. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License, version 3,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 
/***********************************************************************
 * $Id: iloFormParser.y 80545 2017-07-19 08:05:23Z daramix $
 **********************************************************************/
/***********************************************************************
 * ATTENTION : 
 ***********************************************************************
 * This file must be generated by flex 2.5.33 with -R option
 * If you update iloFormParser.y, please follow this procedure.
 1) make formclean
 2) make form
 3) commit iloFormParser.y
 4) commit iloFormParser.cpp
 5) commit iloFormParser.hpp
 **********************************************************************/

%pure_parser
%defines
%parse-param{yyscan_t yyscanner}
%lex-param{yyscan_t yyscanner}
%lex-param{ALTIBASE_ILOADER_HANDLE aHandle}
%parse-param{ALTIBASE_ILOADER_HANDLE aHandle}

%{
/* This is YACC Source for syntax Analysis of iLoader Form file */

//#define _ILOADER_DEBUG
//#undef  _ILOADER_DEBUG

#include <ilo.h>
%}

%union{
SInt          num;
SChar        *str;
iloTableNode *pNode;
}

%{

#if defined(VC_WIN32)
# include <malloc.h>
#endif

#define PARAM ((iloaderHandle *) aHandle)

#define LEX_BODY 0
#define ERROR_BODY 0

#define SKIP_MASK   1
#define NOEXP_MASK  2
#define BINARY_MASK 4
SInt Formlex(YYSTYPE * yylval_param, yyscan_t yyscanner, void *param );
void Formerror ( yyscan_t yyscanner, void *, const SChar *s);
SChar *ltrim(SChar *s);
SChar *rtrim(SChar *s);
/* BUG-17563 : iloader  ūǥ ̿ Naming Rule    */
/* src string "..." -> ...  . */
SChar *eraseDQuotes(SChar *aSrc);

/* BUG-40310 [ux-iloader] Fail to handle where condition when 'WHERE' keyword has mixed case.
 - Add T_WHERE token */
%}

%token T_SEMICOLON T_COMMA T_LBRACE T_RBRACE T_LBRACKET T_RBRACKET T_PERIOD T_ASSIGN
%token T_DOWNLOAD T_SEQUENCE T_TABLE T_QUEUE
%token T_DATEFORMAT_CMD T_SKIP T_ADD T_TIMESTAMP_DEFAULT T_TIMESTAMP_NULL T_NOEXP T_HINT T_BINARY T_OUTFILE
%token T_DATA_NLS_USE T_NCHAR_UTF16 
%token T_PARTITION
%token <str> T_TIMESTAMP_VALUE T_CONDITION
%token <str> T_IDENTIFIER T_STRING T_TIMEFORMAT T_DATEFORMAT T_NOTERM_DATEFORMAT T_OPTIONAL_DATEFORMAT T_CHARSET T_WHERE
%token <num> T_NUMBER T_ZERO

%type <str> user_object_name column_name identifier_keyword function_option partition_name
%type <pNode> ILOADER_FORM DOWN_COND_DEF SEQ_DEF TABLE_DEF ATTRIBUTE_DEF_LIST SEQ_DEF_LIST FORM_OPTION_LIST PARTITION_DEF
%type <pNode> ATTRIBUTE_DEF DATEFORMAT_DEF DATA_NLS_USE_DEF NCHAR_UTF16_DEF FORM_OPTION
%type <num> SKIP_DEF SKIPNOEXP_DEF
%type <str> T_SEQUENCE T_QUEUE T_DOWNLOAD T_HINT T_NOEXP T_DATEFORMAT_CMD T_BINARY T_SKIP T_OUTFILE
%type <str> T_DATA_NLS_USE T_NCHAR_UTF16
%start ILOADER_FORM

%%

ILOADER_FORM
    : TABLE_DEF FORM_OPTION_LIST
      {
          PARAM->mParser.mTableNode = NULL;
          $$ = new iloTableNode(TABLE_NODE, NULL, $1, NULL);
          //gTableTree.SetTreeRoot($$);
           PARAM->mParser.mTableNodeParser = $$;
      }
    | SEQ_DEF_LIST TABLE_DEF FORM_OPTION_LIST
      {
          PARAM->mParser.mTableNode = NULL;
          $$ = new iloTableNode(TABLE_NODE, (SChar *)"seq", $2, NULL);
          //gTableTree.SetTreeRoot($$);
           PARAM->mParser.mTableNodeParser = $$;
          //idlOS::printf("## HERE SEQUENCE SEQ_DEF PARSING ##");
      }
    ;

// BUG-25359 iloader  download condition   ʽϴ.
FORM_OPTION_LIST
    : { /* empty */ }
    | FORM_OPTION_LIST FORM_OPTION
    ;

FORM_OPTION
    : DOWN_COND_DEF
    | DATEFORMAT_DEF
    | DATA_NLS_USE_DEF
    | PARTITION_DEF
    | NCHAR_UTF16_DEF
    ;

DOWN_COND_DEF
    : T_DOWNLOAD T_CONDITION T_WHERE
      {
        if( PARAM->mParser.mTableNode->m_Condition == NULL)
        {
            /* BUG-17563 : iloader  ūǥ ̿ Naming Rule    */
            $$ = new iloTableNode(DOWN_NODE, eraseDQuotes($3), NULL, NULL);
            PARAM->mParser.mTableNode->m_Condition = $$;
        }
        else
        {
              uteSetErrorCode(PARAM->mErrorMgr, utERR_ABORT_Dup_Option_Error, "download condition");
              
              if ( PARAM->mUseApi != SQL_TRUE )
              {
                utePrintfErrorCode(stdout, PARAM->mErrorMgr);
              }
              YYABORT;
        }
      }
    |  T_DOWNLOAD T_CONDITION T_WHERE T_HINT T_STRING
      {
        if( PARAM->mParser.mTableNode->m_Condition == NULL)
        {
            /* BUG-17563 : iloader  ūǥ ̿ Naming Rule    */
            $$ = new iloTableNode(DOWN_NODE, eraseDQuotes($3), NULL, NULL, eraseDQuotes($5));
            PARAM->mParser.mTableNode->m_Condition = $$;
        }
        else
        {
              uteSetErrorCode(PARAM->mErrorMgr, utERR_ABORT_Dup_Option_Error, "download condition");
              if ( PARAM->mUseApi != SQL_TRUE )
              {
                utePrintfErrorCode(stdout, PARAM->mErrorMgr);
               }
              YYABORT;
        }
      }
    ;

SEQ_DEF_LIST
    : SEQ_DEF | SEQ_DEF_LIST SEQ_DEF
    ;

SEQ_DEF
    : T_SEQUENCE user_object_name user_object_name
      {
          InsertSeq( PARAM, $2, $3, (SChar *)"nextval");
          //idlOS::printf("## HERE SEQUENCE");
      }
    | T_SEQUENCE user_object_name user_object_name T_IDENTIFIER
      {
          if (idlOS::strCaselessMatch($4, "CURRVAL") == 0)
          {
              InsertSeq( PARAM, $2, $3, (SChar*) "currval");
          }
          else if (idlOS::strCaselessMatch($4, "NEXTVAL") == 0)
          {
              InsertSeq( PARAM, $2, $3, (SChar *)"nextval");
          }
          else
          {
              YYABORT;
          }
      }
    ;

DATEFORMAT_DEF
    : T_DATEFORMAT_CMD T_DATEFORMAT
      {
          idlOS::strcpy(PARAM->mParser.mDateForm, $2);
      }
    | T_DATEFORMAT_CMD T_NOTERM_DATEFORMAT
      {
          idlOS::strcpy(PARAM->mParser.mDateForm, $2);
      }
    | T_DATEFORMAT_CMD T_TIMEFORMAT
      {
          idlOS::strcpy(PARAM->mParser.mDateForm, $2);
      }
    | T_DATEFORMAT_CMD T_DATEFORMAT T_TIMEFORMAT
      {
          idlOS::strcpy(PARAM->mParser.mDateForm, $2);
          idlOS::strcat(PARAM->mParser.mDateForm, " ");
          idlOS::strcat(PARAM->mParser.mDateForm, $3);
      }
    | T_DATEFORMAT_CMD T_OPTIONAL_DATEFORMAT
      {
          SInt len  = 0;
          idlOS::strcpy(PARAM->mParser.mDateForm, $2);
          len = idlOS::strlen($2);
          PARAM->mParser.mDateForm[0] = ' ';
          PARAM->mParser.mDateForm[len-1] = ' ';
          // fix BUG-25532 [CodeSonar::strcpyWithOverlappingRegions]
          ltrim(PARAM->mParser.mDateForm);
          rtrim(PARAM->mParser.mDateForm);
      }
      ;

DATA_NLS_USE_DEF
    : T_DATA_NLS_USE T_ASSIGN T_IDENTIFIER
      {
          // save DATA_NLS_USE, ex) KO16KSC5601
          idlOS::strncpy(PARAM->mProgOption->m_DataNLS, $3, MAX_WORD_LEN);
      }
    | T_DATA_NLS_USE T_ASSIGN T_CHARSET
      {
          // bug-23282: euc-jp parsing
          idlOS::strncpy(PARAM->mProgOption->m_DataNLS, $3, MAX_WORD_LEN);
      }
    ;

PARTITION_DEF
    : T_PARTITION partition_name
    {     
           /* BUG-30463 */
           idlOS::strncpy(PARAM->mParser.mPartitionName, $2, MAX_OBJNAME_LEN);
           PARAM->mProgOption->mPartition = ILO_TRUE;
    }
    ;

NCHAR_UTF16_DEF
    : T_NCHAR_UTF16 T_ASSIGN T_IDENTIFIER
      {
          if (idlOS::strcasecmp($3, "YES") == 0)
          {
             PARAM->mProgOption->mNCharUTF16 = ILO_TRUE; 
          } 
          else
          {
             PARAM->mProgOption->mNCharUTF16 = ILO_FALSE; 
          }
      }
    ;

TABLE_DEF
    : T_TABLE user_object_name T_LBRACE ATTRIBUTE_DEF_LIST T_RBRACE
      {
          $$ = new iloTableNode(TABLENAME_NODE, $2, $4, NULL);
          PARAM->mParser.mTableNode = $$;
      }
    | T_QUEUE user_object_name T_LBRACE ATTRIBUTE_DEF_LIST T_RBRACE
      {
          $$ = new iloTableNode(TABLENAME_NODE, $2, $4, NULL, 1);
          PARAM->mParser.mTableNode = $$;
      }
    ;

ATTRIBUTE_DEF_LIST
    : ATTRIBUTE_DEF_LIST ATTRIBUTE_DEF
      {
          iloTableNode *pAttr;

          pAttr = $1;
          while (pAttr->GetBrother() != NULL)
              pAttr = pAttr->GetBrother();
          pAttr->SetBrother($2);
          $$ = $1;
      }
    | ATTRIBUTE_DEF
      {
          $$ = $1;
      }
    ;

function_option
    : T_STRING
    {
        /* BUG-17563 : iloader  ūǥ ̿ Naming Rule    */
        $$ = eraseDQuotes($1);
    }
    | /* empty */
    {
        $$ = NULL;
    }

ATTRIBUTE_DEF
    : column_name T_IDENTIFIER T_LBRACKET T_NUMBER T_RBRACKET SKIPNOEXP_DEF function_option T_SEMICOLON
      {
          iloTableNode *pAttrName, *pAttrType;

          if ( idlOS::strcasecmp($2, "CHAR") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"char", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              /* BUG-26485 iloader  trim  ߰ؾ մϴ. */
              /* ڰ Է ڿ մϴ. */
              $$ = new iloTableNode(ATTR_NODE, $7, pAttrName, NULL);
              $$->setSkipFlag($6 & SKIP_MASK);
              $$->setBinaryFlag($6 & BINARY_MASK);
              $$->setPrecision($4, 0);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx char(n)\n");
#endif
          }
          else if ( idlOS::strcasecmp($2, "VARCHAR") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"varchar", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, $7, pAttrName, NULL);
              $$->setSkipFlag($6 & SKIP_MASK);
              $$->setBinaryFlag($6 & BINARY_MASK);
              $$->setPrecision($4, 0);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx varchar(n)\n");
#endif
          }
          else if ( idlOS::strcasecmp($2, "NCHAR") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"nchar", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, $7, pAttrName, NULL);
              $$->setSkipFlag($6 & SKIP_MASK);
              $$->setBinaryFlag($6 & BINARY_MASK);
              $$->setPrecision($4, 0);
              PARAM->mProgOption->mNCharColExist = ILO_TRUE;
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx nchar(n)\n");
#endif
          }
          else if ( idlOS::strcasecmp($2, "NVARCHAR") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"nvarchar", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, $7, pAttrName, NULL);
              $$->setSkipFlag($6 & SKIP_MASK);
              $$->setBinaryFlag($6 & BINARY_MASK);
              $$->setPrecision($4, 0);
              PARAM->mProgOption->mNCharColExist = ILO_TRUE;
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx nvarchar(n)\n");
#endif
          }
          else if ( idlOS::strcasecmp($2, "NIBBLE") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"nibble", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, $7, pAttrName, NULL);
              $$->setSkipFlag($6 & SKIP_MASK);
              $$->setPrecision($4, 0);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx nibble(n)\n");
#endif
          }
          else if ( ( idlOS::strcasecmp($2, "BYTES") == 0 ) ||
                    ( idlOS::strcasecmp($2, "BYTE") == 0 ) ) // BUG-35273
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"byte", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, $7, pAttrName, NULL);
              $$->setSkipFlag($6 & SKIP_MASK);
              $$->setPrecision($4, 0);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx byte(n)\n");
#endif
          }
          else if ( ( idlOS::strcasecmp($2, "VARBYTE") == 0 ) ||
                    ( idlOS::strcasecmp($2, "RAW") == 0 ) )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"varbyte", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, $7, pAttrName, NULL);
              $$->setSkipFlag($6 & SKIP_MASK);
              $$->setPrecision($4, 0);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx varbyte(n)\n");
#endif
          }
          else if ( idlOS::strcasecmp($2, "BIT") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"bit", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, $7, pAttrName, NULL);
              $$->setSkipFlag($6 & SKIP_MASK);
              $$->setPrecision($4, 0);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx bit(n)\n");
#endif
          }
          else if ( idlOS::strcasecmp($2, "VARBIT") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"varbit", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, $7, pAttrName, NULL);
              $$->setSkipFlag($6 & SKIP_MASK);
              $$->setPrecision($4, 0);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx varbit(n)\n");
#endif
          }
          else if ( idlOS::strcasecmp($2, "DOUBLE") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"double", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, $7, pAttrName, NULL);
              $$->setSkipFlag($6 & SKIP_MASK);
              $$->setPrecision(0, 0);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx double(n)\n");
#endif
          }
          else if ( idlOS::strcasecmp($2, "NUMERIC") == 0 ||
                    idlOS::strcasecmp($2, "NUMBER") == 0 ||
                    idlOS::strcasecmp($2, "DECIMAL") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"numeric_long", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, $7, pAttrName, NULL);
              $$->setSkipFlag($6 & SKIP_MASK);
              $$->setNoExpFlag($6 & NOEXP_MASK);
              $$->setPrecision($4, 0);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx numeric(n)\n");
#endif
          }
          else if ( idlOS::strcasecmp($2, "FLOAT") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"float", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, $7, pAttrName, NULL);
              $$->setSkipFlag($6 & SKIP_MASK);
              $$->setNoExpFlag($6 & NOEXP_MASK);
              $$->setPrecision($4, 0);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx float(n)\n");
#endif
          }
          /* BUG-24359 Geometry Formfile */
          else if ( idlOS::strcasecmp($2, "GEOMETRY") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"geometry", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, NULL, pAttrName, NULL);
              $$->setSkipFlag($6 & SKIP_MASK);
              $$->setBinaryFlag($6 & BINARY_MASK);
              $$->setPrecision($4, 0);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx geometry(n)\n");
#endif
          }

          else
          {
              uteSetErrorCode(PARAM->mErrorMgr,
                              utERR_ABORT_Not_Support_dataType_Error,
                              $2,
                              "(n)",
                              "",
                              "");
              if ( PARAM->mUseApi != SQL_TRUE )
              {
                utePrintfErrorCode(stdout, PARAM->mErrorMgr);
              }
              YYABORT;
          }
      }

    | column_name T_IDENTIFIER T_LBRACKET T_ZERO T_RBRACKET SKIPNOEXP_DEF function_option T_SEMICOLON
      {
          iloTableNode *pAttrName, *pAttrType;

          if ( idlOS::strcasecmp($2, "BIT") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"bit", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              /* BUG-26485 iloader  trim  ߰ؾ մϴ. */
              /* ڰ Է ڿ մϴ. */
              $$ = new iloTableNode(ATTR_NODE, $7, pAttrName, NULL);
              $$->setSkipFlag($6 & SKIP_MASK);
              $$->setPrecision($4, 0);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx bit(n)\n");
#endif
          }
          else if ( idlOS::strcasecmp($2, "VARBIT") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"varbit", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, $7, pAttrName, NULL);
              $$->setSkipFlag($6 & SKIP_MASK);
              $$->setPrecision($4, 0);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx varbit(n)\n");
#endif
          }
          else
          {
              YYABORT;
          }
      }

      //PROJ-2030, CT_CASE-3020 CHAR outfile 
    | column_name T_IDENTIFIER T_LBRACKET T_NUMBER T_RBRACKET T_OUTFILE T_SEMICOLON
      {
          iloTableNode *pAttrName, *pAttrType;
          
          if ( idlOS::strcasecmp($2, "CHAR") == 0 )
          {   
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"char", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, NULL, pAttrName, NULL);
              $$->setPrecision($4, 0);
              $$->setOutFileFlag(1);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx char(n) outfile\n");
#endif    
          }
          else if ( idlOS::strcasecmp($2, "VARCHAR") == 0 )
          {   
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"varchar", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, NULL, pAttrName, NULL);
              $$->setPrecision($4, 0);
              $$->setOutFileFlag(1);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx varchar(n) outfile\n");
#endif    
          }
          else if ( idlOS::strcasecmp($2, "NCHAR") == 0 )
          { 
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"nchar", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, NULL, pAttrName, NULL);
              $$->setPrecision($4, 0);
              $$->setOutFileFlag(1);
              PARAM->mProgOption->mNCharColExist = ILO_TRUE; 
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx nchar(n) outfile\n");
#endif
          }
          else if ( idlOS::strcasecmp($2, "NVARCHAR") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"nvarchar", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, NULL, pAttrName, NULL);
              $$->setPrecision($4, 0);
              $$->setOutFileFlag(1);
              PARAM->mProgOption->mNCharColExist = ILO_TRUE;
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx nvarchar(n) outfile\n");
#endif
          }

          else
          {
              uteSetErrorCode(PARAM->mErrorMgr,
                              utERR_ABORT_Not_Support_dataType_Error,
                              $2,
                              "(n)",
                              "",
                              "");
              if ( PARAM->mUseApi != SQL_TRUE )
              {
                  utePrintfErrorCode(stdout, PARAM->mErrorMgr);
              }
              YYABORT;
          }
      }

    // BUG-8679  column DATE FORMAT
    | column_name T_IDENTIFIER T_DATEFORMAT_CMD T_STRING SKIP_DEF T_SEMICOLON
      {
          iloTableNode *pAttrName, *pAttrType;

          if ( idlOS::strcasecmp($2, "DATE") == 0 )
          {
              PARAM->mParser.mDateForm[0] = '\0';
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"date", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              // nodeValue  dateFormat ҷ 
              /* BUG-17563 : iloader  ūǥ ̿ Naming Rule    */
              $$ = new iloTableNode(ATTR_NODE, eraseDQuotes($4), pAttrName, NULL);
              $$->setSkipFlag($5);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx date\n");
#endif
          }
          else
          {
              uteSetErrorCode(PARAM->mErrorMgr,
                              utERR_ABORT_Not_Support_dataType_Error,
                              $2,
                              "",
                              "",
                              "");
              if ( PARAM->mUseApi != SQL_TRUE )
              {
                 utePrintfErrorCode(stdout, PARAM->mErrorMgr);
              }
              YYABORT;
          }
      }

// added by leekmo
    | column_name T_IDENTIFIER SKIPNOEXP_DEF function_option T_SEMICOLON
      {

          iloTableNode *pAttrName, *pAttrType;

          if ( idlOS::strcasecmp($2, "DOUBLE") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"double", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              /* BUG-26485 iloader  trim  ߰ؾ մϴ. */
              /* ڰ Է ڿ մϴ. */
              $$ = new iloTableNode(ATTR_NODE, $4, pAttrName, NULL);
              $$->setSkipFlag($3 & SKIP_MASK);
              $$->setPrecision(0, 0);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx double\n");
#endif
          }
          else if ( idlOS::strcasecmp($2, "SMALLINT") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"smallint", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, $4, pAttrName, NULL);
              $$->setSkipFlag($3 & SKIP_MASK);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx smallint\n");
#endif
          }
          else if ( idlOS::strcasecmp($2, "BIGINT") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"bigint", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, $4, pAttrName, NULL);
              $$->setSkipFlag($3 & SKIP_MASK);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx bigint\n");
#endif
          }
          else if ( idlOS::strcasecmp($2, "INTEGER") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"integer", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, $4, pAttrName, NULL);
              $$->setSkipFlag($3 & SKIP_MASK);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx integer\n");
#endif
          }
          else if ( idlOS::strcasecmp($2, "BOOLEAN") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"boolean", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, $4, pAttrName, NULL);
              $$->setSkipFlag($3 & SKIP_MASK);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx boolean\n");
#endif
          }
          else if ( idlOS::strcasecmp($2, "BLOB") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"blob", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, $4, pAttrName, NULL);
              $$->setSkipFlag($3 & SKIP_MASK);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx blob\n");
#endif
          }
          else if ( idlOS::strcasecmp($2, "CLOB") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"clob", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, $4, pAttrName, NULL);
              $$->setSkipFlag($3 & SKIP_MASK);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx clob\n");
#endif
          }
          else if ( idlOS::strcasecmp($2, "REAL") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"real", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, $4, pAttrName, NULL);
              $$->setSkipFlag($3 & SKIP_MASK);
              $$->setPrecision(0, 0);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx real\n");
#endif
          }
          else if ( idlOS::strcasecmp($2, "FLOAT") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"float", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, $4, pAttrName, NULL);
              $$->setSkipFlag($3 & SKIP_MASK);
              $$->setNoExpFlag($3 & NOEXP_MASK);
              $$->setPrecision(38, 0);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx float\n");
#endif
          }
          else if ( idlOS::strcasecmp($2, "NUMERIC") == 0 ||
                    idlOS::strcasecmp($2, "NUMBER") == 0 ||
                    idlOS::strcasecmp($2, "DECIMAL") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"numeric_long", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, $4, pAttrName, NULL);
              $$->setSkipFlag($3 & SKIP_MASK);
              $$->setNoExpFlag($3 & NOEXP_MASK);
              $$->setPrecision(38, 0);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx numeric\n");
#endif
          }
          else if ( idlOS::strcasecmp($2, "DATE") == 0 )
          {
              PARAM->mParser.mDateForm[0] = '\0';
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"date", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, NULL, pAttrName, NULL);
              $$->setSkipFlag($3 & SKIP_MASK);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx date\n");
#endif
          }
          else if ( idlOS::strcasecmp($2, "TIMESTAMP") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"timestamp", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, NULL, pAttrName, NULL);
              $$->setSkipFlag($3 & SKIP_MASK);
              $$->setPrecision(8, 0);
              PARAM->mParser.mTimestampType = ILO_TIMESTAMP_DAT;
              PARAM->mParser.mAddFlag = ILO_FALSE;
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx timestamp 1\n");
#endif
          }
          else
          {
              uteSetErrorCode(PARAM->mErrorMgr,
                              utERR_ABORT_Not_Support_dataType_Error,
                              $2,
                              "",
                              "",
                              "");
              if ( PARAM->mUseApi != SQL_TRUE )
              {
                utePrintfErrorCode(stdout, PARAM->mErrorMgr);
              }
              YYABORT;
          }
      }

    | column_name T_IDENTIFIER T_SKIP T_TIMESTAMP_DEFAULT T_SEMICOLON
      {
          if ( idlOS::strcasecmp($2, "TIMESTAMP") == 0 )
          {
              iloTableNode *pAttrName, *pAttrType;

              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"timestamp", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, NULL, pAttrName, NULL);
              $$->setSkipFlag(1);
              $$->setPrecision(8, 0);
              PARAM->mParser.mTimestampType = ILO_TIMESTAMP_DEFAULT;
              PARAM->mParser.mAddFlag = ILO_FALSE;
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx timestamp 2\n");
#endif
          }
          else
          {
              uteSetErrorCode(PARAM->mErrorMgr,
                              utERR_ABORT_Not_Support_dataType_Error,
                              $2,
                              "",
                              "SKIP ",
                              "DEFAULT");
              if ( PARAM->mUseApi != SQL_TRUE )
              {
                utePrintfErrorCode(stdout, PARAM->mErrorMgr);
              }
              YYABORT;
          }
      }
    | column_name T_IDENTIFIER T_SKIP T_TIMESTAMP_NULL T_SEMICOLON
      {
          if ( idlOS::strcasecmp($2, "TIMESTAMP") == 0 )
          {
              iloTableNode *pAttrName, *pAttrType;

              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"timestamp", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, NULL, pAttrName, NULL);
              $$->setSkipFlag(1);
              $$->setPrecision(8, 0);
              PARAM->mParser.mTimestampType = ILO_TIMESTAMP_NULL;
              PARAM->mParser.mAddFlag = ILO_FALSE;
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx timestamp 3\n");
#endif
          }
          else
          {
              uteSetErrorCode(PARAM->mErrorMgr,
                              utERR_ABORT_Not_Support_dataType_Error,
                              $2,
                              "",
                              "SKIP ",
                              "NULL");
              if ( PARAM->mUseApi != SQL_TRUE )
              {
                utePrintfErrorCode(stdout, PARAM->mErrorMgr);
              }
              YYABORT;
          }
      }
    | column_name T_IDENTIFIER T_SKIP T_TIMESTAMP_VALUE T_SEMICOLON
      {
          if ( idlOS::strcasecmp($2, "TIMESTAMP") == 0 )
          {
              iloTableNode *pAttrName, *pAttrType;

              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"timestamp", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, NULL, pAttrName, NULL);
              $$->setSkipFlag(1);
              $$->setPrecision(8, 0);
              PARAM->mParser.mTimestampType = ILO_TIMESTAMP_VALUE;
              idlOS::strcpy(PARAM->mParser.mTimestampVal, $4);
              PARAM->mParser.mAddFlag = ILO_FALSE;
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx timestamp 4\n");
#endif
          }
          else
          {
              uteSetErrorCode(PARAM->mErrorMgr,
                              utERR_ABORT_Not_Support_dataType_Error,
                              $2,
                              "",
                              "SKIP ",
                              $4);
              if ( PARAM->mUseApi != SQL_TRUE )
              {
                utePrintfErrorCode(stdout, PARAM->mErrorMgr);
              }
              YYABORT;
          }
      }
    | column_name T_IDENTIFIER T_ADD T_TIMESTAMP_DEFAULT T_SEMICOLON
      {
          if ( idlOS::strcasecmp($2, "TIMESTAMP") == 0 )
          {
              iloTableNode *pAttrName, *pAttrType;

              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"timestamp", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, NULL, pAttrName, NULL);
              $$->setPrecision(8, 0);
              PARAM->mParser.mTimestampType = ILO_TIMESTAMP_DEFAULT;
              PARAM->mParser.mAddFlag = ILO_TRUE;
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx timestamp 2\n");
#endif
          }
          else
          {
              uteSetErrorCode(PARAM->mErrorMgr,
                              utERR_ABORT_Not_Support_dataType_Error,
                              $2,
                              "",
                              "ADD ",
                              "DEFAULT");
              if ( PARAM->mUseApi != SQL_TRUE )
              {
                utePrintfErrorCode(stdout, PARAM->mErrorMgr);
              }
              YYABORT;
          }
      }
    | column_name T_IDENTIFIER T_ADD T_TIMESTAMP_NULL T_SEMICOLON
      {
          if ( idlOS::strcasecmp($2, "TIMESTAMP") == 0 )
          {
              iloTableNode *pAttrName, *pAttrType;

              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"timestamp", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, NULL, pAttrName, NULL);
              $$->setPrecision(8, 0);
              PARAM->mParser.mTimestampType = ILO_TIMESTAMP_NULL;
              PARAM->mParser.mAddFlag = ILO_TRUE;
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx timestamp 3\n");
#endif
          }
          else
          {
              uteSetErrorCode(PARAM->mErrorMgr,
                              utERR_ABORT_Not_Support_dataType_Error,
                              $2,
                              "",
                              "ADD ",
                              "NULL");
              if ( PARAM->mUseApi != SQL_TRUE )
              {
                utePrintfErrorCode(stdout, PARAM->mErrorMgr);
              }              
              YYABORT;
          }
      }
    | column_name T_IDENTIFIER T_ADD T_TIMESTAMP_VALUE T_SEMICOLON
      {
          if ( idlOS::strcasecmp($2, "TIMESTAMP") == 0 )
          {
              iloTableNode *pAttrName, *pAttrType;

              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"timestamp", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, NULL, pAttrName, NULL);
              $$->setPrecision(8, 0);
              PARAM->mParser.mTimestampType = ILO_TIMESTAMP_VALUE;
              idlOS::strcpy(PARAM->mParser.mTimestampVal, $4);
              PARAM->mParser.mAddFlag = ILO_TRUE;
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx timestamp 4\n");
#endif
          }
          else
          {
              uteSetErrorCode(PARAM->mErrorMgr,
                              utERR_ABORT_Not_Support_dataType_Error,
                              $2,
                              "",
                              "ADD ",
                              $4);
              if ( PARAM->mUseApi != SQL_TRUE )
              {
                utePrintfErrorCode(stdout, PARAM->mErrorMgr);
              }
              YYABORT;
          }
      }

    | column_name T_IDENTIFIER T_LBRACKET T_NUMBER T_COMMA T_ZERO T_RBRACKET SKIPNOEXP_DEF function_option T_SEMICOLON
      {
          if ( idlOS::strcasecmp($2, "NUMERIC") == 0 ||
               idlOS::strcasecmp($2, "NUMBER") == 0 ||
               idlOS::strcasecmp($2, "DECIMAL") == 0 )
          {
              iloTableNode *pAttrName, *pAttrType;

              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"numeric_long", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              /* BUG-26485 iloader  trim  ߰ؾ մϴ. */
              /* ڰ Է ڿ մϴ. */
              $$ = new iloTableNode(ATTR_NODE, $9, pAttrName, NULL);
              $$->setSkipFlag($8 & SKIP_MASK);
              $$->setNoExpFlag($8 & NOEXP_MASK);
              $$->setPrecision($4, 0);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx numeric(n, 0)\n");
#endif
          }
          else
          {
              uteSetErrorCode(PARAM->mErrorMgr,
                              utERR_ABORT_Not_Support_dataType_Error,
                              $2,
                              "(n, 0)",
                              "",
                              "");
              if ( PARAM->mUseApi != SQL_TRUE )
              {
                utePrintfErrorCode(stdout, PARAM->mErrorMgr);
              }
              YYABORT;
          }
      }

    | column_name T_IDENTIFIER T_LBRACKET T_NUMBER T_COMMA T_NUMBER T_RBRACKET SKIPNOEXP_DEF function_option T_SEMICOLON
      {
          iloTableNode *pAttrName, *pAttrType;

          if ( idlOS::strcasecmp($2, "NUMERIC") == 0 ||
               idlOS::strcasecmp($2, "NUMBER") == 0 ||
               idlOS::strcasecmp($2, "DECIMAL") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"numeric_double", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              /* BUG-26485 iloader  trim  ߰ؾ մϴ. */
              /* ڰ Է ڿ մϴ. */
              $$ = new iloTableNode(ATTR_NODE, $9, pAttrName, NULL);
              $$->setSkipFlag($8 & SKIP_MASK);
              $$->setNoExpFlag($8 & NOEXP_MASK);
              $$->setPrecision($4, $6);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx numeric(n, m)\n");
#endif
          }
          else
          {
              uteSetErrorCode(PARAM->mErrorMgr,
                              utERR_ABORT_Not_Support_dataType_Error,
                              $2,
                              "(n, m)",
                              "",
                              "");
              if ( PARAM->mUseApi != SQL_TRUE )
              {
                utePrintfErrorCode(stdout, PARAM->mErrorMgr);
              }
              YYABORT;
          }
      }
    // BUG-24757 geometry precision over eight digit.
    | column_name T_IDENTIFIER T_LBRACKET T_TIMESTAMP_VALUE T_RBRACKET SKIPNOEXP_DEF T_SEMICOLON
      {
          iloTableNode *pAttrName, *pAttrType;          
          if ( idlOS::strcasecmp($2, "GEOMETRY") == 0 )
          {
              pAttrType = new iloTableNode(ATTRTYPE_NODE, (SChar *)"geometry", NULL, NULL);
              pAttrName = new iloTableNode(ATTRNAME_NODE, $1, NULL, pAttrType);
              $$ = new iloTableNode(ATTR_NODE, NULL, pAttrName, NULL);
              $$->setSkipFlag($6 & SKIP_MASK);
              $$->setBinaryFlag($6 & BINARY_MASK);

              $$->setPrecision(idlOS::atoi($4), 0);
#ifdef _ILOADER_DEBUG
              idlOS::printf("xx geometry(n)\n");
#endif
          }

          else
          {
              uteSetErrorCode(PARAM->mErrorMgr,
                              utERR_ABORT_Not_Support_dataType_Error,
                              $2,
                              "(n)",
                              "",
                              "");
              if ( PARAM->mUseApi != SQL_TRUE )
              {
                utePrintfErrorCode(stdout, PARAM->mErrorMgr);
              }
              YYABORT;
          }
      }

    ;
/* BUG-19173 */
identifier_keyword
    : T_IDENTIFIER
      {
          $$ = $1;
      }
    | T_DOWNLOAD
      {
          $$ = $1;
      }
    | T_CONDITION
      {
          $$ = $1;
      }
    | T_HINT
      {
          $$ = $1;
      }
    | T_NOEXP
      {
          $$ = $1;
      }
    | T_SKIP
      {
          $$ = $1;
      }
    | T_DATEFORMAT_CMD
      {
          $$ = $1;
      }
    | T_BINARY
      {
          $$ = $1;
      }
    | T_DATA_NLS_USE
      {
          $$ = $1;
      }
    | T_NCHAR_UTF16
      {
          $$ = $1;
      }
    | T_CHARSET
      {
          $$ = $1;
      }
    | T_NOTERM_DATEFORMAT
      {
          $$ = $1;
      }
    | T_TIMEFORMAT
      {
          $$ = $1;
      }
    | T_OUTFILE
      {
          $$ = $1;
      }
   | T_DATEFORMAT
      {
          /* BUG-28843 */
          $$ = $1;
      }
   | T_STRING
      {
          /* BUG-17563 : iloader  ūǥ ̿ Naming Rule    */
          /* table/column ̸ case  "..."Ͱ string ü ־ */
          $$ = $1;
      }
    ;

user_object_name
    : identifier_keyword
    {/* BUG-19173 */
          $$ = $1;
      }
    | identifier_keyword T_PERIOD identifier_keyword
      {
          idlOS::sprintf(PARAM->mParser.mTmpBuf, "%s.%s", $1, $3);
          $$ = PARAM->mParser.mTmpBuf;
      }
    ;

column_name
    : identifier_keyword
      { /* BUG-19173 */
          $$ = $1;
      }
    /* BUG-12091 */
    | T_SEQUENCE
      {
          $$ = $1;
      }
    | T_QUEUE
      {
          $$ = $1;
      }
    ;

SKIP_DEF
    : /* empty */
      {
          $$ = 0;
      }
    | T_SKIP
      {
          $$ = 1;
      }
    ;

SKIPNOEXP_DEF
    : /* empty */
      {
          $$ = 0;
      }
    | T_SKIP
      {
          $$ = SKIP_MASK;
      }
    | T_NOEXP
      {
          $$ = NOEXP_MASK;
      }
    | T_SKIP T_NOEXP
      {
          $$ = SKIP_MASK | NOEXP_MASK;
      }
    | T_NOEXP T_SKIP
      {
          $$ = SKIP_MASK | NOEXP_MASK;
      }
    | T_BINARY
      {
          $$ = BINARY_MASK;
      }
    ;

partition_name
    : identifier_keyword
    {
        /* BUG-30463 */
        $$ = $1;
    }
    ;
%%

