/***********************************************************************
 * Copyright 1999-2015, ALTIBASE Corporation or its subsidiaries.
 * All rights reserved.
 **********************************************************************/

CREATE PACKAGE BODY DBMS_RECYCLEBIN AS

PROCEDURE PURGE_USER_RECYCLEBIN AS
TYPE NAME_ARRAY IS TABLE OF VARCHAR(128) INDEX BY INTEGER;

SQL    VARCHAR(256);
N      INTEGER;
TABLES NAME_ARRAY;
BEGIN
  SELECT TABLE_NAME BULK COLLECT INTO TABLES
    FROM SYSTEM_.SYS_TABLES_ T, SYSTEM_.SYS_USERS_ U
    WHERE U.USER_ID = USER_ID() AND U.USER_ID = T.USER_ID AND T.TABLE_TYPE ='R';

  FOR N IN TABLES.FIRST() .. TABLES.LAST() LOOP
      SQL := 'PURGE TABLE "' || USER_NAME() || '"."' || TABLES(N)|| '"';
      BEGIN
         EXECUTE IMMEDIATE SQL;
      EXCEPTION WHEN OTHERS THEN
         NULL;
      END;
  END LOOP;
END;

PROCEDURE PURGE_ALL_RECYCLEBIN AS
TYPE NAME_ARRAY IS TABLE OF VARCHAR(128) INDEX BY INTEGER;

SQL    VARCHAR(256);
N      INTEGER;
TABLES NAME_ARRAY;
USERS  NAME_ARRAY;
BEGIN
  SELECT TABLE_NAME, USER_NAME BULK COLLECT INTO TABLES, USERS
    FROM SYSTEM_.SYS_TABLES_ T, SYSTEM_.SYS_USERS_ U
    WHERE U.USER_ID = T.USER_ID AND T.TABLE_TYPE ='R';

  FOR N IN TABLES.FIRST() .. TABLES.LAST() LOOP
      SQL := 'PURGE TABLE "' || USERS(N) || '"."' || TABLES(N)|| '"';
      BEGIN
         EXECUTE IMMEDIATE SQL;
      EXCEPTION WHEN OTHERS THEN
         NULL;
      END;
  END LOOP;
END;

PROCEDURE PURGE_TABLESPACE( TABLESPACE_NAME IN VARCHAR(64) ) AS
TYPE NAME_ARRAY IS TABLE OF VARCHAR(128) INDEX BY INTEGER;

SQL              VARCHAR(256);
N                INTEGER;
TABLESPACE_NAME_ VARCHAR(64);
TABLES           NAME_ARRAY;
USERS            NAME_ARRAY;
BEGIN
  IF INSTR( TABLESPACE_NAME, CHR(34) ) = 0 THEN
      TABLESPACE_NAME_ := UPPER( TABLESPACE_NAME );
  ELSE
      TABLESPACE_NAME_ := REPLACE2( TABLESPACE_NAME, CHR(34) );
  END IF;

  SELECT TABLE_NAME, USER_NAME BULK COLLECT INTO TABLES, USERS
    FROM SYSTEM_.SYS_TABLES_ T, SYSTEM_.SYS_USERS_ U
    WHERE T.TBS_NAME = TABLESPACE_NAME_ AND
          U.USER_ID = T.USER_ID AND
          T.TABLE_TYPE ='R';

  FOR N IN TABLES.FIRST() .. TABLES.LAST() LOOP
      SQL := 'PURGE TABLE "' || USERS(N) || '"."' || TABLES(N)|| '"';
      BEGIN
         EXECUTE IMMEDIATE SQL;
      EXCEPTION WHEN OTHERS THEN
         NULL;
      END;
  END LOOP;
END;

PROCEDURE PURGE_ORIGINAL_NAME( ORIGINAL_NAME IN VARCHAR(128) ) AS
TYPE NAME_ARRAY IS TABLE OF VARCHAR(128) INDEX BY INTEGER;

SQL            VARCHAR(256);
N              INTEGER;
ORIGINAL_NAME_ VARCHAR(128);
TABLES         NAME_ARRAY;
BEGIN
  IF INSTR( ORIGINAL_NAME, CHR(34) ) = 0 THEN
      ORIGINAL_NAME_ := UPPER( ORIGINAL_NAME );
  ELSE
      ORIGINAL_NAME_ := REPLACE2( ORIGINAL_NAME, CHR(34) );
  END IF;

  SELECT TABLE_NAME BULK COLLECT INTO TABLES
    FROM SYSTEM_.SYS_TABLES_ T, SYSTEM_.SYS_USERS_ U
    WHERE U.USER_ID = USER_ID() AND
          U.USER_ID = T.USER_ID AND
          ORIGINAL_NAME_ = SUBSTRB(T.TABLE_NAME, 1, LENGTHB(T.TABLE_NAME) - 32) AND
          T.TABLE_TYPE = 'R';
  FOR N IN TABLES.FIRST() .. TABLES.LAST() LOOP
      SQL := 'PURGE TABLE "' || USER_NAME() || '"."' || TABLES(N)|| '"';
      BEGIN
         EXECUTE IMMEDIATE SQL;
      EXCEPTION WHEN OTHERS THEN
         NULL;
      END;
  END LOOP;
END;

END;
/
