/***********************************************************************
 * Copyright 1999-2017, Altibase Corporation or its subsidiaries.
 * All rights reserved.
 **********************************************************************/

CREATE OR REPLACE PACKAGE BODY utl_smtp AS

FUNCTION open_connection( host       IN VARCHAR(64),
                          port       IN INTEGER,
                          tx_timeout IN INTEGER DEFAULT NULL )
RETURN CONNECT_TYPE
AS
    CONNECT_HANDLE CONNECT_TYPE;
    CHECK_VALUE INTEGER;
    RETURN_TEXT VARCHAR(512);
    RECEIVE_SIZE INTEGER;
    PROTOCOL_TYPE INTEGER;
BEGIN
    RECEIVE_SIZE := 512;
    PROTOCOL_TYPE := 1;
    CONNECT_HANDLE := OPEN_CONNECT( host, port, NULL, NULL );
    IF ( CONNECT_HANDLE IS NOT NULL ) THEN
        RETURN_TEXT := RECV_TEXT( CONNECT_HANDLE, RECEIVE_SIZE );
        CHECK_VALUE := CHECK_CONNECT_REPLY( PROTOCOL_TYPE, RETURN_TEXT );
    END IF;
    RETURN CONNECT_HANDLE;
END;
 
FUNCTION helo( c       IN CONNECT_TYPE,
               domain  IN VARCHAR(64) )
RETURN VARCHAR(512)
AS
    CHECK_VALUE INTEGER;
    COMMAND VARCHAR(512);
    RETURN_TEXT VARCHAR(512);
    RECEIVE_SIZE INTEGER;
    PROTOCOL_TYPE INTEGER;
    CONNECT_STATE INTEGER;
BEGIN
    RECEIVE_SIZE := 512;
    PROTOCOL_TYPE := 1;
    CONNECT_STATE := 2;
    CHECK_VALUE := CHECK_CONNECT_STATE( c, CONNECT_STATE );
    COMMAND := 'HELO ' || TRIM( domain ) || CHR(13) || CHR(10);
    CHECK_VALUE := SEND_TEXT( c, COMMAND, LENGTH( COMMAND ) );
    IF ( CHECK_VALUE > 0 ) THEN
        RETURN_TEXT := RECV_TEXT( c, RECEIVE_SIZE );
        CHECK_VALUE := CHECK_CONNECT_REPLY( PROTOCOL_TYPE, RETURN_TEXT );
    END IF;
    RETURN RETURN_TEXT;
END;

FUNCTION mail( c         IN CONNECT_TYPE,
               sender    IN VARCHAR(256),
               paramters IN VARCHAR DEFAULT NULL )
RETURN VARCHAR(512)
AS
    CHECK_VALUE INTEGER;
    COMMAND VARCHAR(512);
    RETURN_TEXT VARCHAR(512);
    RECEIVE_SIZE INTEGER;
    PROTOCOL_TYPE INTEGER;
    CONNECT_STATE BIGINT;
BEGIN
    RECEIVE_SIZE := 512;
    PROTOCOL_TYPE := 1;
    CONNECT_STATE := 3;
    CHECK_VALUE := CHECK_CONNECT_STATE( c, CONNECT_STATE );
    COMMAND := 'MAIL FROM:<' || TRIM( sender ) || '>' || CHR(13) || CHR(10);
    CHECK_VALUE := SEND_TEXT( c, COMMAND, LENGTH( COMMAND ) );
    IF ( CHECK_VALUE > 0 ) THEN
        RETURN_TEXT := RECV_TEXT( C, RECEIVE_SIZE );
        CHECK_VALUE := CHECK_CONNECT_REPLY( PROTOCOL_TYPE, RETURN_TEXT );
    END IF;
    RETURN RETURN_TEXT;
END;

FUNCTION rcpt( c         IN CONNECT_TYPE,
               recipient IN VARCHAR(256),
               paramters IN VARCHAR DEFAULT NULL )
RETURN VARCHAR(512)
AS
    CHECK_VALUE INTEGER;
    COMMAND VARCHAR(512);
    RETURN_TEXT VARCHAR(512);
    RECEIVE_SIZE INTEGER;
    PROTOCOL_TYPE INTEGER;
    CONNECT_STATE BIGINT;
BEGIN
    RECEIVE_SIZE := 512;
    PROTOCOL_TYPE := 1;
    CONNECT_STATE := 4;
    CHECK_VALUE := CHECK_CONNECT_STATE( c, CONNECT_STATE );
    COMMAND := 'RCPT TO:<' || TRIM( recipient ) || '>' || CHR(13) || CHR(10);
    CHECK_VALUE := SEND_TEXT( c, COMMAND, LENGTH( COMMAND ) );
    IF ( CHECK_VALUE > 0 ) THEN
        RETURN_TEXT := RECV_TEXT( C, RECEIVE_SIZE );
        CHECK_VALUE := CHECK_CONNECT_REPLY( PROTOCOL_TYPE, RETURN_TEXT );
    END IF;
    RETURN RETURN_TEXT;
END;

FUNCTION open_data( c IN CONNECT_TYPE )
RETURN VARCHAR(512)
AS
    CHECK_VALUE INTEGER;
    COMMAND VARCHAR(512);
    RETURN_TEXT VARCHAR(512);
    RECEIVE_SIZE INTEGER;
    PROTOCOL_TYPE INTEGER;
    CONNECT_STATE BIGINT;
BEGIN
    RECEIVE_SIZE := 512;
    PROTOCOL_TYPE := 1;
    CONNECT_STATE := 5;
    CHECK_VALUE := CHECK_CONNECT_STATE( c, CONNECT_STATE );
    COMMAND := 'DATA' || CHR(13) || CHR(10);
    CHECK_VALUE := SEND_TEXT( c, COMMAND, LENGTH( COMMAND ) );
    IF ( CHECK_VALUE > 0 ) THEN
        RETURN_TEXT := RECV_TEXT( c, RECEIVE_SIZE );
        CHECK_VALUE := CHECK_CONNECT_REPLY( PROTOCOL_TYPE, RETURN_TEXT );
    END IF;
    RETURN RETURN_TEXT;
END;

PROCEDURE write_data( c    IN CONNECT_TYPE,
                      data IN VARCHAR(65534) )
AS
    CHECK_VALUE INTEGER;
    RETURN_TEXT VARCHAR(512);
    RECEIVE_SIZE INTEGER;
    CONNECT_STATE BIGINT;
BEGIN
    RECEIVE_SIZE := 0;
    CONNECT_STATE := 6;
    CHECK_VALUE := CHECK_CONNECT_STATE( c, CONNECT_STATE );
    CHECK_VALUE := SEND_TEXT( c, data, LENGTH( data ) );
    IF ( CHECK_VALUE > 0 ) THEN
        RETURN_TEXT := RECV_TEXT( c, RECEIVE_SIZE );
    END IF;
END;

PROCEDURE write_raw_data( c    IN CONNECT_TYPE,
                          data IN RAW(65534) )
AS
    CHECK_VALUE INTEGER;
    RETURN_TEXT VARCHAR(512);
    RECEIVE_SIZE INTEGER;
    CONNECT_STATE BIGINT;
BEGIN
    RECEIVE_SIZE := 0;
    CONNECT_STATE := 6;
    CHECK_VALUE := CHECK_CONNECT_STATE( c, CONNECT_STATE );
    CHECK_VALUE := WRITE_RAW_VALUE( c, data, raw_sizeof( data ) - 4 );
    IF ( CHECK_VALUE > 0 ) THEN
        RETURN_TEXT := RECV_TEXT( c, RECEIVE_SIZE );
    END IF;
END;


FUNCTION close_data( c IN CONNECT_TYPE )
RETURN VARCHAR(512)
AS
    CHECK_VALUE INTEGER;
    COMMAND VARCHAR(512);
    RETURN_TEXT VARCHAR(512);
    RECEIVE_SIZE INTEGER;
    PROTOCOL_TYPE INTEGER;
    CONNECT_STATE BIGINT;
BEGIN
    RECEIVE_SIZE := 512;
    PROTOCOL_TYPE := 1;
    CONNECT_STATE := 7;
    CHECK_VALUE := CHECK_CONNECT_STATE( c, CONNECT_STATE );
    COMMAND := CHR(13) || CHR(10) || '.' || CHR(13) || CHR(10);
    CHECK_VALUE := SEND_TEXT( c, COMMAND, LENGTH( COMMAND ) );
    IF ( CHECK_VALUE > 0 ) THEN
        RETURN_TEXT := RECV_TEXT( c, RECEIVE_SIZE );
        CHECK_VALUE := CHECK_CONNECT_REPLY( PROTOCOL_TYPE, RETURN_TEXT );
    END IF;
    RETURN RETURN_TEXT;
END;

FUNCTION quit( c IN CONNECT_TYPE )
RETURN VARCHAR(512)
AS
    CHECK_VALUE INTEGER;
    COMMAND VARCHAR(512);
    RETURN_TEXT VARCHAR(512);
    RECEIVE_SIZE INTEGER;
    PROTOCOL_TYPE INTEGER;
    CONNECT_STATE BIGINT;    
BEGIN
    RECEIVE_SIZE := 512;
    PROTOCOL_TYPE := 1;
    CONNECT_STATE := 1;
    CHECK_VALUE := CHECK_CONNECT_STATE( c, CONNECT_STATE );
    COMMAND := 'QUIT' || CHR(13) || CHR(10);
    CHECK_VALUE := SEND_TEXT( c, COMMAND, LENGTH( COMMAND ) );
    IF ( CHECK_VALUE > 0 ) THEN
        RETURN_TEXT := RECV_TEXT( c, RECEIVE_SIZE );
        CHECK_VALUE := CHECK_CONNECT_REPLY( PROTOCOL_TYPE, RETURN_TEXT );
    END IF;
    CHECK_VALUE := CLOSE_CONNECT(c);
    RETURN RETURN_TEXT;
END;

END;
/
